<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Struk Pembelian</title>
    <style>
    body {
        font-family: monospace, Arial, sans-serif;
        font-size: 12px;
        background: #fff;
        color: #000; /* Pastikan warna teks utama hitam */
        font-weight: bold; /* Jadikan semua teks di body tebal secara default */
    }
    .struk {
        width: 56mm;
        margin: 0 auto;
        padding: 0;
    }
    .text-center, .center {
        text-align: center;
        font-weight: bold; /* Pastikan teks di tengah juga tebal */
    }
    .bold {
        font-weight: bold;
    }
    .line {
        border-top: 1px dashed #000;
        margin: 5px 0;
    }
    .right {
        text-align: right;
    }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    td {
        vertical-align: top;
        padding: 0;
        margin: 0;
        color: #000; /* Pastikan teks di dalam tabel hitam */
        font-weight: bold; /* Jadikan teks di dalam tabel tebal */
    }
    #backBtn { display: none; width: 100%; margin: 10px 0; }
    @media print {
        html, body {
            width: 58mm !important;
            min-width: 58mm !important;
            max-width: 58mm !important;
            margin: 1mm !important;
            padding: 0 !important;
            background: #fff !important;
            box-sizing: border-box;
            color: #000 !important; /* Paksa teks hitam saat dicetak */
            font-weight: bold !important; /* Paksa teks tebal saat dicetak */
        }
        .struk {
            width: 56mm !important;
            min-width: 56mm !important;
            max-width: 56mm !important;
            margin: 0 auto !important;
            padding: 0 !important;
        }
        #backBtn { display: none !important; }
    }
</style>

</head>
<body>
    <div class="struk">
        <div class="text-center bold">FITNESS CENTER</div>
        <div class="text-center">Jl. Contoh No. 1, Kota</div>
        <div class="text-center">WA: 08123456789</div>
        <div class="line"></div>
        <div>
            Tgl: {{ \Carbon\Carbon::parse($purchase->tanggal)->format('d-m-Y H:i:s') }}<br>
            Pembeli: {{ $purchase->member->nama ?? $purchase->nama_pembeli ?? '-' }}<br>
            Payment: {{ $purchase->payment_method }}
        </div>
        <div class="line"></div>
        <table>
        @foreach($purchase->details as $d)
            <tr>
                <td colspan="2">{{ $d->product->nama ?? 'Produk ID:'.$d->product_id }}</td>
            </tr>
            <tr>
                <td>{{ $d->qty }} x {{ number_format($d->harga_satuan,0,',','.') }}</td>
                <td class="right">{{ number_format($d->qty * $d->harga_satuan,0,',','.') }}</td>
            </tr>
        @endforeach
        </table>
        <div class="line"></div>
        <table>
            <tr>
                <td>Total</td>
                <td class="right">{{ number_format($purchase->total_harga,0,',','.') }}</td>
            </tr>
            <tr>
                <td>Bayar</td>
                <td class="right">{{ number_format($purchase->bayar,0,',','.') }}</td>
            </tr>
            <tr>
                <td>Kembali</td>
                <td class="right">{{ number_format($purchase->kembali,0,',','.') }}</td>
            </tr>
        </table>
        <div class="line"></div>
        <div class="text-center">
            --- Terima Kasih ---
        </div>
        <button id="backBtn">Kembali</button>
    </div>
    <script>
    function isMobile() {
        return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }
    window.onload = function() {
        window.print();
        if (!isMobile()) {
            window.onafterprint = function() {
                window.location.href = "{{ route('purchases.index') }}";
            };
        } else {
            document.getElementById('backBtn').style.display = 'block';
        }
    };
    document.getElementById('backBtn').onclick = function() {
        window.location.href = "{{ route('purchases.index') }}";
    };
    </script>
</body>
</html>